/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SessionPrivileges
implements ToXContentObject,
Writeable,
Serializable {
    private static final long serialVersionUID = 8836312044879615458L;
    static final String PARAM_COMPACT = "compact";
    static final ToXContent.Params COMPACT = new ToXContent.MapParams((Map)ImmutableMap.of((Object)"compact", (Object)"true"));
    private final List<String> backendRoles;
    private final List<String> searchGuardRoles;
    private final Map<String, Object> attributes;

    public SessionPrivileges(Collection<String> backendRoles, Collection<String> searchGuardRoles, Map<String, Object> attributes) {
        this.backendRoles = Collections.unmodifiableList(new ArrayList<String>(backendRoles));
        this.searchGuardRoles = Collections.unmodifiableList(new ArrayList<String>(searchGuardRoles));
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
    }

    public SessionPrivileges(StreamInput in) throws IOException {
        this.backendRoles = in.readStringList();
        this.searchGuardRoles = in.readStringList();
        this.attributes = in.readMap();
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public List<String> getSearchGuardRoles() {
        return this.searchGuardRoles;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean compact = params.paramAsBoolean(PARAM_COMPACT, false);
        builder.startObject();
        if (this.backendRoles.size() > 0) {
            builder.field(compact ? "r_be" : "roles_be", this.backendRoles);
        }
        if (this.searchGuardRoles.size() > 0) {
            builder.field(compact ? "r_sg" : "roles_sg", this.searchGuardRoles);
        }
        if (this.attributes.size() > 0) {
            builder.field(compact ? "a" : "attrs", this.attributes);
        }
        builder.endObject();
        return builder;
    }

    public static SessionPrivileges parse(DocNode jsonNode) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        ImmutableList backendRoles = vJsonNode.get("roles_be").asList().withEmptyListAsDefault().ofStrings();
        ImmutableList searchGuardRoles = vJsonNode.get("roles_sg").asList().withEmptyListAsDefault().ofStrings();
        Object attributes = vJsonNode.get("attrs").asMap();
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        return new SessionPrivileges((Collection<String>)backendRoles, (Collection<String>)searchGuardRoles, (Map<String, Object>)attributes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.backendRoles);
        out.writeStringCollection(this.searchGuardRoles);
        out.writeMap(this.attributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.backendRoles == null ? 0 : this.backendRoles.hashCode());
        result = 31 * result + (this.searchGuardRoles == null ? 0 : this.searchGuardRoles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionPrivileges other = (SessionPrivileges)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.backendRoles == null ? other.backendRoles != null : !this.backendRoles.equals(other.backendRoles)) {
            return false;
        }
        return !(this.searchGuardRoles == null ? other.searchGuardRoles != null : !this.searchGuardRoles.equals(other.searchGuardRoles));
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

